%% Simulate option data for the TFSV model

alpha1=0.028;
alpha2=0.130;
beta1=0;
beta2=5.58;
sigmav1=1.039;
sigmav2=0.667;
rho1=-0.775;
rho2=-0.382;
r=0.05; %changed to 5 percent 
%dividend equals zero
N=1000000;
M=100;
T=1;

v1_0=0.01;%0.4;
v2_0=0.01;%0.4;
F_0=300+200;

[spath6,S0]=Simulate_Diffusion_tfsv(r,alpha1,alpha2,beta1,beta2,sigmav1,sigmav2,rho1,rho2,N,M,T,F_0,v1_0,v2_0); %added interest rate
Kvec=150:2:450;

K1 = 100:10:200;
K2 = 200:5:250;
K3 = 250:2:280;
K4 = 280:1:320;
K5 = 320:2:350;
K6 = 350:5:400;
K7 = 400:10:500;
Kvec=[K1,K2,K3,K4,K5,K6,K7]+200;
Kvec=unique(Kvec);


dt=T/M;disc = exp(-r*dt);discc = exp(-r*T);
 [prices_put, stdErrs_put] = Price_MC_American_Strikes_func(spath6, disc, 0, Kvec );
% 
 prices_eo_put=Price_MC_EO_Strikes_func(spath6,discc,0,Kvec);
% 
 [prices_call, stdErrs_call] = Price_MC_American_Strikes_func(spath6, disc, 1, Kvec );
% 
 prices_eo_call=Price_MC_EO_Strikes_func(spath6,discc,1,Kvec);
save("sv2_spd1y1.mat",'prices_put','stdErrs_put','prices_eo_put','prices_call','stdErrs_call','prices_eo_call','S0')
[f,xi]=ksdensity(spath6(1:N,101));plot(xi,f);
save("sv2_den1y1.mat",'xi','f');
